//
//  MCReachability.h
//  OfflineSyncClient
//
//  Created by Brent Gulanowski on 09-09-16.
//  Copyright 2009 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <SystemConfiguration/SystemConfiguration.h>


// This is a cheap knock-off of class found on Touch OS
// Just updates its properties in response to notifications

// TODO: bjg - add support for other reachability flags

@interface MCReachability : NSObject {

	NSString *hostname;
	SCNetworkReachabilityRef reachabilityRef;
	
	BOOL isLocal;
	BOOL isDirect;
	BOOL isReachable;
}

@property (nonatomic, retain) NSString *hostname;

@property (nonatomic) BOOL isLocal;
@property (nonatomic) BOOL isDirect;
@property (nonatomic) BOOL isReachable;

- (id)initWithHostName:(NSString *)hostname;

- (BOOL)registerForUpdates;
- (void)unregister;

@end
